# Building in Windows 10/11 with Linux subsystem (WSL) [Recommended]

Linux subsystem for Windows (WSL) 10/11 is probably the simplest way of building INAV under Windows.

## Setting up the environment

Enable WSL:
run `windows features`
enable `windows subsytem for linux`
reboot

Install Ubuntu:
1.  Go to Microsoft store https://www.microsoft.com/en-gb/store/b/home
1.  Search and install most recent Ubuntu LTS version
1.  When download completed, select `Launch Ubuntu`
1.  When prompted enter a user name and password which you will need to remember
1.  When complete, the linux command prompt will be displayed

NOTE: from this point all commands are entered into the Ubunto shell command window

Update the repo packages:
-  `sudo apt update`

Install Git, Make, gcc and Ruby
-  `sudo apt-get install git make cmake ruby`

Install python and python-yaml to allow updates to settings.md
-  `sudo apt-get install python3`

### CMAKE and Ubuntu 18_04

To run  `cmake` in the latest version you will need to update from Ubuntu `18_04` to `20_04`. The fastest way to do it is to uninstall current version and install `20_04` for Microsoft Store [https://www.microsoft.com/store/productId/9N6SVWS3RX71](https://www.microsoft.com/store/productId/9N6SVWS3RX71) 

## Downloading the INAV repository (example):

Mount MS windows C drive and clone INAV
1.   `cd /mnt/c`
2.   `git clone https://github.com/iNavFlight/inav.git`
3.   `git checkout 6.1.1` (to switch to a specific release tag, for this example INAV version 6.1.1)
4.   `git checkout -b my-branch` (to create own branch)

You are ready!
You now have a folder called inav in the root of C drive that you can edit in windows

### If you get a cloning error

On some installations, you may see the following error:
```
Cloning into 'inav'...
error: chmod on /mnt/c/inav/.git/config.lock failed: Operation not permitted
fatal: could not set 'core.filemode' to 'false'
```

You can fix this with by remounting the drive using the following commands
1. `sudo umount /mnt/c`
2. `sudo mount -t drvfs C: /mnt/c -o metadata`

## Building with Make (example):

For detailed build instructions see [Building in Linux](Building%20in%20Linux.md)

Launch Ubuntu:
Click Windows Start button then scroll and launch "Ubuntu"

Building from Ubuntu command line

`cd /mnt/c/inav`

Do it onece to prepare build environment
```
mkdir build
cd build
cmake ..
```

Then to build
```
cd build
make MATEKF722
```

## Building with Ninja (example):

[Ninja](https://ninja-build.org/) is a popular cross-platform tool. It is both lightweight and executes parallel builds by default. It is advantageous to use this over the old _make_ method. There are detailed instructions for building with Ninja in [Building in Linux](Building%20in%20Linux.md#building-with-ninja).

Launch Ubuntu:
Click Windows Start button. Then scroll and launch **Ubuntu**.

> [!TIP]
> Before using Ninja, you will need to install it. From the Ubuntu command prompt type `sudo apt-get install ninja-build -y` and press enter.

Building from the command line:

First, change to the INAV directory with 
```cd /mnt/c/inav```

Before building, you will need to prepare the build environment. You only need to do this once, unless you reinstall WSL or cmake.

```
mkdir build
cd build
cmake -GNinja ..
```

From then on, you can build your target by calling the following from inside the build directory.
```
ninja MATEKF722
```

If you want to build multiple targets. You can use:
```
ninja MATEKF722 MATEKF405SE SPEEDYBEEF405
```

## Updating the documents
```
cd /mnt/c/inav
python3 src/utils/update_cli_docs.py
```

## Flashing:
Launch windows configurator GUI and from within the firmware flasher select `Load firmware[Local]`
Hex files can be found in the folder `c:\inav\build`

## Troubleshooting

### Syntax error: "(" unexpected

```
dzikuvx@BerlinAtHome:/mnt/c/Users/pspyc/Documents/Projects/inav/build$ make MATEKF722SE
Generating MATEKF722SE/settings_generated.h, MATEKF722SE/settings_generated.c
/bin/sh: 1: Syntax error: "(" unexpected
make[3]: *** [src/main/target/MATEKF722SE/CMakeFiles/MATEKF722SE.elf.dir/build.make:63: src/main/target/MATEKF722SE/MATEKF722SE/settings_generated.h] Error 2
make[2]: *** [CMakeFiles/Makefile2:33607: src/main/target/MATEKF722SE/CMakeFiles/MATEKF722SE.elf.dir/all] Error 2
make[1]: *** [CMakeFiles/Makefile2:33290: src/main/target/MATEKF722SE/CMakeFiles/MATEKF722SE.dir/rule] Error 2
make: *** [Makefile:13703: MATEKF722SE] Error 2
```

This error can be triggered by a Windows PATHs included in the Linux Subsystem. The solution is:

#### For WSL V1 - Flags set as 7 by default

1. Open Windows RegEdit tool
1. Find `HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Lxss\{GUID}\Flags`
1. Change `Flags` from `7` to `5`
1. Restart WSL and Windows preferably
1. `cd build`
1. `cmake ..`
1. `make {TARGET}` should be working again 

#### For WSL V2 - Flags set as 0x0000000f (15) by default
1. Open Windows RegEdit tool
1. Find `HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Lxss\{GUID}\Flags`
1. Change `Flags` from `f` to `d`, it is stored as Base Hexadecimal
1. Restart WSL and Windows preferably
1. `cd build`
1. `cmake ..`
1. `make {TARGET}` should be working again 

#### Or, for either version
1. In the Linux Subsystem, `cd /etc/`
2. Create a new file with `sudo nano wsl.conf`
3. Enter the following in to the new file:
```
[Interop]
appendWindowsPath=false
```
4. Save the file by holding `Ctrl` and pressing `o`
5. Press `Enter` to confirm the wsl.conf filename.
6. Hit `Ctrl`+`x` to exit nano
7. Restart WSL and Windows preferably
8. `cd build`
9. `cmake ..`
9. `make {TARGET}` should be working again 

### Building targets is very slow
I was pretty shocked when my new i7 -10750 laptop took 25 minutes to build a single target. My old i3-4030 could do the same job in about 2.5 minutes. If you're also suffering from slow builds. Open an elevated PowerShell window and type
```
wsl -l -v
```
If you see your Linux distribution is using WSL 2, this is the problem. WSL 2 is quicker than WSL 1 for a lot of things. However, if your files are on a windows mounted drive in Linux, it is extremely slow. There are two options:
1. Put your files on the Linux file system
2. Change to WSL 1

#### Using the Linux file system (recommended)
To use the Linux file system, make sure the distro is running. Open File Explorer and navigate to `\\wsl$`. In that path you will find your distros listed. At this point, map a network drive to your distro. Inside the distro, you can find your home directory at `/home/~username~/`. Create your GitHub folders here.

If after this you have problems with writing to the directories from within VSCode. Open the application for your distro and type
```
sudo chown -R ~username~ GitHub
```
`~Username~` is your root distro user that you created and `GitHub` should be the root folder for your GitHub repositories.

#### To switch back to WSL 1
To do this, in the elevated PowerShell window, you can see the name of your distro. Mine is **Ubuntu-20.04**, so I'll use that in this example. Simply type
```
wsl --set-version Ubuntu-20.04 1
```
and your distro will be converted to WSL 1. Once finished, reboot your system. Next time you compile a build, it will be faster.
